// Input handling
up_key = keyboard_check_pressed(vk_up);
down_key = keyboard_check_pressed(vk_down);
accept_key = keyboard_check_pressed(vk_enter);

// Get the number of options in the current menu
op_length = array_length(option[menu_level]);

// Navigate through the menu
pos += down_key - up_key;
if (pos >= op_length) { pos = 0 };
if (pos < 0) { pos = op_length - 1 };

// Handling selected option
if (accept_key) {
    var _sml = menu_level;  // Store the current menu level

    switch(menu_level) {
        // Main menu
        case 0:
            switch(pos) {
                case 0: room_goto_next(); break;  // Start Game
                case 1: menu_level = 1; break;    // Settings
                case 2: game_end(); break;       // Quit Game
            }
            break;

        // Settings menu
        case 1:
            switch(pos) {
                case 0: menu_level = 2; break;  // Go to window size submenu
                case 1: menu_level = 3; break;  // Go to controls submenu
                case 2: menu_level = 4; break;  // Go to objective submenu
                case 3: menu_level = 0; break;  // Back to main menu
            }
            break;

        // Window size submenu (level 2)
        case 2:
            switch(pos) {
                case 0:  // Toggle window size
                    if (option[2, 0] == "Window Size: 1x") {
                        option[2, 0] = "Window Size: 2x";
                        window_set_size(1024, 768);  // Apply 2x size
                    } else if (option[2, 0] == "Window Size: 2x") {
                        option[2, 0] = "Window Size: 3x";
                        window_set_size(1536, 1024);  // Apply 3x size
                    } else if (option[2, 0] == "Window Size: 3x") {
                        option[2, 0] = "Window Size: 1x";
                        window_set_size(864, 648);  // Apply 1x size
                    }
                    break;
                case 1:  // Toggle fullscreen
                    global.fullscreen_enabled = !global.fullscreen_enabled;
                    window_set_fullscreen(global.fullscreen_enabled);  // Apply fullscreen
                    break;
                case 2:  // Back to settings
                    menu_level = 1;
                    break;
            }
            break;

        // Controls submenu (level 3)
        case 3:
            switch(pos) {
                case 4:  // Back to settings menu
                    menu_level = 1;
                    break;
            }
            break;

        // Objective submenu (level 4)
        case 4:
            switch(pos) {
                case 1:  // Back to settings menu
                    menu_level = 1;
                    break;
            }
            break;
    }

    // Reset the selected option to 0 if the menu level changes
    if (_sml != menu_level) { pos = 0 };

    // Update the option length for the new menu level
    op_length = array_length(option[menu_level]);
}

// Play a sound when an option is selected
if (pos != last_selected) audio_play_sound(select, 1, false);
last_selected = pos;
